﻿using System;
using System.Globalization;

namespace NVCC.Models
{
    [Serializable]
    public class DisclosedAppointment
    {
        private const string DateFormat = "MM/dd/yyyyHH:mm:ss";
        public DisclosedAppointment() { }
        public DisclosedAppointment(Appointment appointment)
        {
            LocationName = appointment.Location;
            DateTime parsedDate;

            if (DateTime.TryParseExact(appointment.AppointmentDateTime, DateFormat, CultureInfo.InvariantCulture, DateTimeStyles.AllowWhiteSpaces, out parsedDate))
            {
                AppointmentDateTime = parsedDate;
            }
        }

        public long DisclosedAppointmentId { get; set; }
        public int DisclosureId { get; set; }
        public long AppointmentId { get; set; }
        public string LocationName { get; set; }
        public DateTime? AppointmentDateTime { get; set; }
    }
}